--version 0.2
function AddPlayerPostInitFunction(post_init_fn)
	AddPlayerPostInit( function(player)
		if player.name ~= "unknown" then
			post_init_fn(player) 
		end
	end)
end

function AddPlayerComponent(name, init_fn)
	AddPlayerPostInitFunction( function(player)
		if not player.components[name] then
			player:AddComponent(name)
			if(init_fn) then
				init_fn(player.components[name])
			end
		end
	end)
end

function AddPrefabPostInitFunction(prefab_name, post_init_fn)
	AddPrefabPostInit(prefab_name, function(prefab)
   		if prefab ~= nil then
     		post_init_fn(prefab)
  		end
	end)
end

--function AddClassPostConstructFunction(class_name, post_construct_fn)
--	AddClassPostConstruct(class_name, post_construct_fn)
--end